require('dotenv').config();

module.exports = {
  bot: {
    name: process.env.BOT_NAME || 'WhatsDesk Pro',
    company: process.env.COMPANY_NAME || 'Your Company',
    sessionName: process.env.SESSION_NAME || 'whatsdesk-pro-bot'
  },

  translation: {
    projectId: process.env.GOOGLE_PROJECT_ID,
    credentials: process.env.GOOGLE_APPLICATION_CREDENTIALS,
    defaultLanguage: process.env.DEFAULT_LANGUAGE || 'en'
  },

  businessHours: {
    timezone: process.env.TIMEZONE || 'America/Sao_Paulo',
    start: process.env.BUSINESS_HOURS_START || '08:00',
    end: process.env.BUSINESS_HOURS_END || '18:00',
    days: (process.env.BUSINESS_DAYS || '1,2,3,4,5').split(',').map(Number)
  },

  // System access control
  admins: (process.env.ADMIN_NUMBERS || '').split(',').filter(Boolean),
  agents: (process.env.AGENTS_NUMBERS || '').split(',').filter(Boolean),

  notifications: {
    ticketTimeout: parseInt(process.env.TICKET_TIMEOUT_MINUTES || '15'),
    agentResponseTimeout: parseInt(process.env.AGENT_RESPONSE_TIMEOUT_MINUTES || '5'),
    clientResponseTimeout: parseInt(process.env.CLIENT_RESPONSE_TIMEOUT_HOURS || '24')
  },

  database: {
    path: process.env.DATABASE_PATH || './data/bot.db'
  },

  media: {
    maxSizeMB: parseInt(process.env.MAX_MEDIA_SIZE_MB || '100'),
    supportedTypes: ['image', 'video', 'audio', 'document']
  },

  // Language names for display
  languageNames: {
    pt: 'Português',
    en: 'English',
    es: 'Español',
    fr: 'Français',
    de: 'Deutsch',
    it: 'Italiano',
    zh: 'Chinese',
    ja: 'Japanese',
    ko: 'Korean',
    hi: 'Hindi'
  }
};
